<?php

namespace App\Repositories;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;

class StatsRepository
{
    private const CACHE_TTL = 300; // 5 minutes

    public function getCount(string $table, array $conditions = []): int
    {
        info($table);
        info($conditions);
        $cacheKey = "stats.count.{$table}." . md5(serialize($conditions));

        return Cache::remember($cacheKey, self::CACHE_TTL, function () use ($table, $conditions) {
            return DB::table($table)
                ->when($conditions, function($query) use ($conditions) {
                    foreach($conditions as $column => $value) {
                        $query->where($column, $value);
                    }
                })
                ->count();
        });
    }

    public function getDailyStats(string $table, string $date, array $conditions = []): int
    {
        $cacheKey = "stats.daily.{$table}.{$date}." . md5(serialize($conditions));

        return Cache::remember($cacheKey, self::CACHE_TTL, function () use ($table, $date, $conditions) {
            return DB::table($table)
                ->whereDate('created_at', $date)
                ->when($conditions, function($query) use ($conditions) {
                    foreach($conditions as $column => $value) {
                        $query->where($column, $value);
                    }
                })
                ->count();
        });
    }
}
